File: /quick-reference/UPGRADE.md

# Upgrade to SaaS OS Pro

SaaS OS Free Edition provides:

- Full Foundations
- Full Tokens
- Button Contract
- Input Contract
- Basic Cursor workflow

It is designed for:
- Learning the system
- Building simple landing pages
- Evaluating the architecture style

---

## What You Unlock in SaaS OS Pro

SaaS OS Pro includes the full system.

### 1. Full Contract Library

- Modal (all variants)
- Complex interaction components
- State-aware components
- Accessibility-bound behavior
- Variant truth tables
- Canonical contract enforcement patterns

Free includes only Button and Input.

---

### 2. Full Prompt Pack

- Structured system rules
- Multi-file generation prompts
- Refactor prompts
- Component enforcement prompts
- Architecture-aligned generation patterns

Free includes a limited basic prompt structure.

---

### 3. SaaS Flows

- Canonical UI flows
- State & feedback modeling
- Navigation and execution boundaries
- Traceable behavior definitions

Free does not include flows.

---

### 4. Engineering Architecture

- Folder ownership rules
- System boundaries
- Traceability validation loop
- Repo structure discipline
- Vendor system integration model

Free edition does not include architectural enforcement rules.

---

### 5. Advanced AI Adapters

- Structured Cursor system rules
- Adapter configuration
- Controlled generation loops
- Stability enforcement patterns

Free includes limited adapter guidance only.

---

## Who Pro Is For

SaaS OS Pro is built for:

- SaaS founders
- Senior engineers
- AI-assisted development teams
- Product builders who need structural consistency
- Teams that want traceable UI behavior

---

## Free vs Pro

Free:
- Build correctly.
- Learn the structure.
- Evaluate the philosophy.

Pro:
- Build scalable SaaS.
- Enforce architectural discipline.
- Generate production-ready systems.
- Maintain long-term stability.

---

## Upgrade Path

Visit:

https://navorix.com

to access the Pro edition.

The system remains the same.

The depth increases.